#include "function.h"

extern BYTE ColorTable[1028];
extern char outputImage[100];

/************************************************************************/
/* Name: drawImage
/* Function: draw one Image.
/* Input: data: store this character.
          id: the order of this character.  
/* Output: 
/* Return:
/* Explain:
/* Amendant record			
/* Date          Edition       Modifier      Summary
/* 10/12/2009    V1.0          Suqin Ao      Establish 
/************************************************************************/
void drawImage(BYTE *data, int id)
{
	//int iNum = vet->num;
	int iHeight =128;
	FILE *fImage;
	char fName[100];
	//char temp[100];

	strcpy(fName, OUTPUT_IMAGE_PATH);
	strcat(fName, "%d_Image.bmp"); 
	sprintf(outputImage, fName, id);

	if(!(fImage = fopen(outputImage, "wb")))
	{
		printf("Cannot open this file!");
		return;
	}
	
	/********write "BM"***********/
	char str[1000];
	strcpy(str, "BM");
	fwrite(str, sizeof(BYTE), 2, fImage);
	
	/********write the size of the file********/
	BYTE size[4];
	BYTE oneAll = 255;
	size[0] = 0X36;
	size[1] = 0X44;
	size[2] = 0;
	size[3] = 0;
	fwrite(size, sizeof(BYTE), 4, fImage);

	/********ignore the reserved********/
	size[0] = 0;
	size[1] = 0;
	size[2] = 0;
	size[3] = 0;
	fwrite(size, sizeof(BYTE), 4, fImage);

	/********write the start position of the image data********/
	size[0] = 0X36;//3EH
	size[1] = 0X04;
	fwrite(size, sizeof(BYTE), 4, fImage);
	
	/********write the size of info header, the default is 28H********/
	size[0] = 40;//28H
	size[1] = 0;
	fwrite(size, sizeof(BYTE), 4, fImage);

	/********write the width, height of image, the default is 128********/
	size[0] = 128;
	fwrite(size, sizeof(BYTE), 4, fImage);
	fwrite(size, sizeof(BYTE), 4, fImage);

	/********write number of planes, the default is 1********/
	size[0] = 1;
	fwrite(size, sizeof(BYTE), 1, fImage);
	fwrite(size, sizeof(BYTE), 1, fImage);

	/********write number of bits to denote a pixel, the default is 8********/
	size[0] = 8;
	fwrite(size, sizeof(BYTE), 2, fImage);


	/********write the way of compressed, the default is 0********/
	size[0] = 0;
	fwrite(size, sizeof(BYTE), 4, fImage);

	/********write size of image data********/
	size[1] = 0X40;//128*128
	fwrite(size, sizeof(BYTE), 4, fImage);

	size[1] = 0;

	int i;
	for(i = 0; i < 3; i ++)
		fwrite(size, sizeof(BYTE), 4, fImage);

	fwrite(ColorTable, sizeof(BYTE), 1028, fImage);

	/********write image data********/

	reverseRow(data);
	
	fwrite(data, sizeof(BYTE), 128 * 128, fImage);
	
	

	fclose(fImage);
}